
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Advertising",
    "Staff Salaries",
    "Travel",
    "Events",
    "Online Campaigns",
    "Fundraising",
    "Consulting",
    "Social Media",
    "Grassroots Campaigns",
    "Merchandise",
    "Polling",
    "Media Relations"
]
differences = [
    25,
    -15,
    10,
    -20,
    30,
    -10,
    15,
    -5,
    40,
    -25,
    35,
    10
]

title = "Difference in Campaign Spending: Candidate A vs. Candidate B"
xlabel = "Difference in Spending (%)"
ylabel = "Campaign Spending Categories"
xlim = [-30, 50]
xticks = range(-30, 51, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff9999" if x < 0 else "#66b3ff" for x in differences]

# Create figure and plot
fig, ax = plt.subplots(figsize=(12, 7))
ax.barh(categories, differences, color=colors, alpha=0.7)

# Set title and labels
ax.set_title(title, fontsize=16, fontweight='bold', color='#333333')
ax.set_xlabel(xlabel, fontsize=14, fontweight='medium', color='#333333')
ax.set_ylabel(ylabel, fontsize=14, fontweight='medium', color='#333333')

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_200.pdf", bbox_inches="tight")
