
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
high_temps = np.array(
    [
        [30, 25, 28],
        [22, 19, 21],
        [15, 14, 13],
        [12, 10, 11],
        [5,  6,  7],
    ]
)
low_temps = np.array(
    [
        [20, 18, 17],
        [15, 14, 13],
        [10,  9,  8],
        [6,  5,  4],
        [0,  2,  1],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Season 1: Winter",
    "Season 2: Spring",
    "Season 3: Summer",
    "Season 4: Autumn",
    "Season 5: Early Winter",
]

xlabel = "City"
ylabel = "Temperature (°C)"
labels = ["Average Highs", "Average Lows"]
ylim = [-30, 40]
xticks = [0, 1, 2]
xticklabels = ["City A", "City B", "City C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 4))

# Define colors
high_temp_color = "#1f77b4"  # Blue color
low_temp_color = "#ff7f0e"   # Orange color

# Create subplots
for i in range(5):
    ax = plt.subplot(1, 5, i + 1)
    ax.bar(x, high_temps[i], width=0.5, label=labels[0], color=high_temp_color)
    ax.bar(x, -low_temps[i], width=0.5, label=labels[1], color=low_temp_color)
    ax.set_title(titles[i])
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], high_temps[i][j] - 2, str(high_temps[i][j]), ha="center"
        )
        ax.text(
            x[j],
            -low_temps[i][j] + 2,
            str(low_temps[i][j]),
            ha="center",
        )

# Add legend to the first subplot
plt.subplot(1, 5, 1).legend(loc="lower right", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_201.pdf", bbox_inches="tight")
