
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the bar charts
co2_emissions = np.array(
    [
        [10.3, 12.5, 14.8],
        [15.3, 17.7, 19.6],
        [20.0, 22.6, 25.5],
        [25.8, 27.2, 29.6],
        [30.3, 32.9, 35.5],
    ]
)
renewable_energy_usage = np.array(
    [
        [5.1, 6.6, 7.7],
        [10.1, 11.5, 13.5],
        [15.5, 17.6, 19.5],
        [20.5, 22.8, 24.8],
        [25.7, 27.6, 29.4],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Region A: Year 1",
    "Region A: Year 2",
    "Region B: Year 1",
    "Region B: Year 2",
    "Region C: Year 1",
]

labels = ["CO2 Emissions", "Renewable Energy Usage"]
ylim = [-40, 40]
xticks = [0, 1, 2]
xticklabels = ["Sector 1", "Sector 2", "Sector 3"]

# Axis labels and supertitle
xlabel = "Sector"
ylabel = "Values (in Millions)"
suptitle = "Environmental Data for Different Regions and Time Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 4))

# Create subplots
for i in range(5):
    ax = plt.subplot(1, 5, i + 1)
    ax.bar(x, co2_emissions[i], width=0.5, label=labels[0], color="#8b4513")
    ax.bar(x, -renewable_energy_usage[i], width=0.5, label=labels[1], color="#4682b4")
    ax.set_title(titles[i], fontsize=10, fontweight='bold')
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], co2_emissions[i][j] - 2, str(co2_emissions[i][j]), ha="center"
        )
        ax.text(
            x[j],
            -renewable_energy_usage[i][j] + 1,
            str(renewable_energy_usage[i][j]),
            ha="center",
        )

# Add legend to the first subplot
plt.subplot(1, 5, 1).legend(loc="lower left", frameon=True)

# Add supertitle
plt.suptitle(suptitle, fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("bar_202.pdf", bbox_inches="tight")
