
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
countries = [
    "USA",
    "Canada",
    "UK",
    "Germany",
    "France",
    "Spain",
    "Italy",
    "Brazil",
    "Mexico",
    "Argentina",
    "China",
    "India",
    "Japan",
    "South Korea",
    "Australia",
    "South Africa",
    "Russia",
    "Turkey",
    "Saudi Arabia",
    "Indonesia",
    "Vietnam",
    "Thailand",
    "Egypt",
    "Nigeria",
    "Sweden",
    "Switzerland",
    "Norway",
    "Netherlands",
]

anxiety_levels = [
    3.5,
    3.0,
    2.8,
    2.6,
    2.4,
    2.3,
    2.2,
    2.1,
    2.0,
    1.9,
    1.8,
    1.7,
    1.6,
    1.5,
    1.4,
    1.3,
    1.2,
    1.1,
    1.0,
    0.9,
    0.8,
    0.7,
    0.6,
    0.5,
    0.4,
    0.3,
    0.2,
    0.1,
]

# Extracted variables
xlim_values = (-1, len(countries))
ylim_values = (-1, 4)
ylabel_text = "Average Anxiety Levels"
title_text = "Average Anxiety Levels by Country"
legend_labels = ["High Anxiety", "Moderate Anxiety", "Low Anxiety"]
yticks_values = [-2, -1, 0, 1, 2, 3, 4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors based on anxiety levels
colors = [
    "#1f77b4" if x < 1 else "#ff7f0e" if 1 <= x <= 2 else "#d62728"
    for x in anxiety_levels
]

# Plot
fig, ax = plt.subplots(figsize=(8, 5))  # Convert mm to inches for figsize
bars = ax.bar(countries, anxiety_levels, color=colors, edgecolor='black', alpha=0.7)

# Labels and Title
ax.set_xlim(*xlim_values)
ax.set_xticks([])
ax.set_ylim(*ylim_values)
ax.set_yticks(yticks_values)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)

# Add text labels
for bar, country in zip(bars, countries):
    y = bar.get_height()
    if y < 0:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            0.2,
            country,
            rotation=90,
            ha="center",
            va="bottom",
        )
    else:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            -0.2,
            country,
            rotation=90,
            ha="center",
            va="top",
        )

# Legend
blue_patch = plt.Rectangle((0, 0), 1, 1, fc="#1f77b4", edgecolor="none")
orange_patch = plt.Rectangle((0, 0), 1, 1, fc="#ff7f0e", edgecolor="none")
red_patch = plt.Rectangle((0, 0), 1, 1, fc="#d62728", edgecolor="none")
ax.legend(
    [blue_patch, orange_patch, red_patch],
    legend_labels,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=3,
    frameon=False,
)

plt.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_205.pdf", bbox_inches="tight")
