

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Placeholder data for average annual temperatures in different regions
regions = [
    "Region A",
    "Region B",
    "Region C",
    "Region D",
    "Region E",
    "Region F",
    "Region G",
    "Region H",
    "Region I",
    "Region J",
    "Region K",
]
temperatures = {
    "Year 1": [14.1, 15.4, 17.2, 19.3, 15.9, 20.9, 14.4, 17.6, 21.3, 24.1, 19.3],
    "Year 2": [16.0, 17.8, 18.2, 19.4, 16.7, 21.4, 17.0, 20.6, 24.5, 25.2, 20.0],
    "Year 3": [18.4, 18.8, 19.8, 20.4, 19.8, 22.0, 20.2, 21.0, 23.8, 26.0, 24.7],
    "Year 4": [17.6, 18.3, 20.4, 21.6, 18.5, 22.1, 19.1, 20.7, 23.4, 25.6, 23.7],
    "Year 5": [18.2, 19.4, 21.2, 22.7, 19.2, 23.3, 18.9, 22.4, 23.7, 27.8, 24.7],
    "Year 6": [19.5, 18.8, 22.0, 23.1, 19.7, 24.8, 19.5, 23.9, 24.8, 27.2, 22.0],
    "Year 7": [17.8, 16.8, 18.6, 19.4, 18.3, 21.6, 17.6, 21.3, 22.2, 23.0, 21.2],
    "Year 8": [18.0, 19.0, 20.0, 22.0, 19.0, 23.0, 20.0, 21.0, 24.0, 25.0, 23.8],
    "Year 9": [19.8, 18.8, 21.8, 22.9, 20.4, 24.1, 19.3, 23.8, 25.2, 26.2, 25.7],
}

ylim = [14, 28]
ylabel = "Average Annual Temperature (°C)"
yticks = [14, 16, 18, 20, 22, 24, 26, 28]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Create subplots for each dataset
n_rows = 3
n_cols = 3
subplot_idx = 1
for year, temperature in temperatures.items():
    ax = plt.subplot(n_rows, n_cols, subplot_idx)
    subplot_idx += 1

    # Create bar chart
    x = np.arange(len(regions))
    colors = [
        "#3E92CC", "#48C9B0", "#F4D03F", "#EC7063", "#AF7AC5",
        "#F39C12", "#52BE80", "#5DADE2", "#E74C3C", "#A569BD", "#F5B041"
    ]
    ax.bar(
        x,
        temperature,
        color=colors,
    )

    # Add data labels
    for j, val in enumerate(temperature):
        ax.text(j, val + 0.2, f"{val:.1f}", ha="center", va="bottom", fontsize=8)

    # Set title and labels
    ax.set_title(year, fontsize=10)
    ax.set_xticks(x)
    ax.set_xticklabels(regions, rotation=45, ha="right", fontsize=8)
    ax.set_ylim(ylim)
    ax.set_ylabel(ylabel, fontsize=9)
    ax.set_yticks(yticks)

    plt.tick_params(axis="both", which="both", length=0)
    ax.grid(True, axis='y', linestyle='--', linewidth=0.7, alpha=0.7)
    ax.set_axisbelow(True)
    ax = plt.gca()

    # Remove top and right spines
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["bottom"].set_color("gray")
    ax.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_207.pdf", bbox_inches="tight")
