
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Placeholder data
categories = [
    "USA",
    "China",
    "India",
    "Russia",
    "Japan",
    "Germany",
    "Brazil",
    "Canada",
    "France",
    "UK",
    "Australia",
]
scores = {
    "2015": [4396, 5232, 1354, 1065, 1023, 578, 538, 651, 478, 314, 248],
    "2016": [4430, 5320, 1395, 1080, 1035, 590, 550, 660, 480, 320, 250],
    "2017": [4500, 5460, 1430, 1102, 1050, 610, 568, 672, 485, 325, 255],
    "2018": [4620, 5650, 1489, 1125, 1080, 630, 580, 680, 490, 330, 260],
    "2019": [4750, 5800, 1540, 1150, 1100, 655, 590, 692, 495, 335, 265],
    "2020": [4800, 5950, 1600, 1175, 1125, 670, 600, 700, 498, 340, 268],
    "2021": [4900, 6100, 1650, 1200, 1150, 690, 610, 710, 500, 345, 270],
}

ylim = [200, 6200]
ylabel = "Annual Electricity Consumption (TWh)"
yticks = [1000, 2000, 3000, 4000, 5000, 6000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Create subplots for each category
n_rows = 3
n_cols = 3
subplot_idx = 1
for category, score in scores.items():
    ax = plt.subplot(n_rows, n_cols, subplot_idx)
    subplot_idx += 1

    # Create bar chart
    x = np.arange(len(categories))
    ax.bar(
        x,
        score,
        color=[
            "#ff9999",
            "#66b3ff",
            "#99ff99",
            "#ffcc99",
            "#c2c2f0",
            "#ffb3e6",
            "#c4e17f",
            "#ffccff",
            "#ff6666",
            "#c2c2f0",
            "#ffb366",
        ],
    )

    # Add data labels
    for j, val in enumerate(score):
        ax.text(j, val + 100, f"{val:.1f}", ha="center", va="bottom", fontsize=6)

    # Set title and labels
    ax.set_title(category, fontsize=10)
    ax.set_xticks(x)
    ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=7)
    ax.set_ylim(ylim)
    ax.set_ylabel(ylabel, fontsize=8)
    ax.set_yticks(yticks)

    ax.tick_params(axis="both", which="both", length=0, labelsize=7)

    # Add y grid
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

    ax.spines["top"].set_color("gray")
    ax.spines["right"].set_color("gray")
    ax.spines["bottom"].set_color("gray")
    ax.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_208.pdf", bbox_inches="tight")


