

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(2)
# Entertainment categories
categories = [
    "Movies",
    "TV Shows",
    "Books",
    "Video Games",
    "Music",
    "Podcasts",
    "Live Shows",
    "Streaming",
    "Theater",
    "Radio",
    "Comics"
]
scores = {
    "Popularity": [
        85.0, 80.0, 75.0, 90.0, 88.0, 70.0, 65.0, 95.0, 60.0, 50.0, 55.0
    ],
    "User Ratings": [
        78.0, 82.0, 79.0, 84.0, 88.0, 73.0, 64.0, 89.0, 68.0, 72.0, 60.0
    ],
    "Critical Ratings": [
        75.0, 70.0, 80.0, 85.0, 90.0, 65.0, 60.0, 95.0, 55.0, 50.0, 58.0
    ],
    "Revenue": [
        95.0, 85.0, 65.0, 98.0, 90.0, 70.0, 60.0, 88.0, 50.0, 40.0, 45.0
    ],
    "Engagement": [
        82.0, 78.0, 85.0, 92.0, 86.0, 75.0, 68.0, 94.0, 66.0, 60.0, 72.0
    ],
}
ylabel = "Performance Metrics (%)"
ylim = [30, 100]
yticks = list(range(30, 110, 10))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Create subplots for each category
n_rows = 3
n_cols = 2
subplot_idx = 1
for category, score in scores.items():
    ax = plt.subplot(n_rows, n_cols, subplot_idx)
    subplot_idx += 1

    # Create bar chart
    x = np.arange(len(categories))
    ax.bar(
        x,
        score,
        color=[
            "#6a9fb5",
            "#b5cde2",
            "#c2cbb1",
            "#f4a582",
            "#92c5de",
            "#fddbc7",
            "#fada5e",
            "#d9d9d9",
            "#c7eae5",
            "#f4a582",
            "#92c5de"
        ],
    )

    # Add data labels
    for j, val in enumerate(score):
        ax.text(j, val + 1, f"{val}", ha="center", va="bottom", fontsize=8)

    # Set title and labels
    ax.set_title(category, fontsize=10)
    ax.set_xticks(x)
    ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=8)
    ax.set_ylim(ylim)
    ax.set_ylabel(ylabel, fontsize=8)
    ax.set_yticks(yticks)

    plt.tick_params(axis="both", which="both", length=0)

    # Add y grid
    plt.gca().yaxis.grid(True)
    plt.gca().set_axisbelow(True)

    ax = plt.gca()
    ax.spines["top"].set_color("gray")
    ax.spines["right"].set_color("gray")
    ax.spines["bottom"].set_color("gray")
    ax.spines["left"].set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_209.pdf", bbox_inches="tight")
