

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Population data for different countries
categories = [
    "China",
    "India",
    "United States",
    "Indonesia",
    "Pakistan",
    "Brazil",
    "Nigeria",
    "Bangladesh",
    "Russia",
]
# in million
population = np.random.randint(50, 1500, size=len(categories))
# annual growth rate in percentage
growth_rate = np.random.uniform(0.5, 2.5, size=len(categories)) * population / 10

# Positions of the bars on the x-axis
r = np.arange(len(categories))

# Labels and text
labels = ["Population (millions)", "Annual Growth Rate (millions)"]
xlabel = "Countries"
ylabel = "Population Statistics"
title = "Population and Annual Growth Rate of Countries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.6

# Color palette
population_color = "#8b0000"       # Dark Red (Burgundy)
growth_rate_color = "#4682b4"      # Steel Blue (Teal)

# Create the figure and the axes
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the bars
ax.bar(
    r,
    population,
    bottom=growth_rate,
    color=population_color,
    width=bar_width,
    label=labels[0],
)
ax.bar(r, growth_rate, color=growth_rate_color, width=bar_width, label=labels[1])

# Add labels, title, and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.legend(loc="upper left")

# Additional style adjustments
ax.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("bar_210.pdf", bbox_inches="tight")
