

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# New dataset relevant to agriculture categories
categories = [
    "Crop Yield",
    "Livestock Production",
    "Fertilizer Use",
    "Irrigation",
    "Pesticide Use",
    "Soil Health",
    "Agri-Tech Adoption",
    "Sustainable Practices",
    "Farm Income",
    "Land Use",
    "Water Management",
    "Climate Impact",
    "Market Access",
    "Subsidy Impact",
    "Labor Efficiency",
    "Genetically Modified Crops",
    "Food Quality",
    "Supply Chain Efficiency",
    "Organic Farming",
    "Policy Support",
]
metric_1_values = np.random.randint(50, 200, size=len(categories))
metric_2_values = np.random.randint(30, 100, size=len(categories))

# Positions of the bars on the x-axis
r = np.arange(len(categories))

labels = [
    "Metric 1: Yield/Production (tons)",
    "Metric 2: Investment (million $)",
]
xlabel = "Agricultural Categories"
ylabel = "Values"
title = "Comparison of Yield/Production and Investment in Various Agricultural Categories"
suptitle = "Agriculture Metrics Analysis"
legend_location = "upper right"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.6

# Create the figure and the axes
fig, ax = plt.subplots(figsize=(10, 8))

# Colors for the bars
color_metric_1 = "#69b3a2"
color_metric_2 = "#8e44ad"

# Plot the bars
ax.bar(
    r, 
    metric_1_values, 
    bottom=metric_2_values, 
    color=color_metric_1, 
    width=bar_width, 
    label=labels[0]
)
ax.bar(r, metric_2_values, color=color_metric_2, width=bar_width, label=labels[1])

# Add labels, titles, and legends
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.set_title(title)
fig.suptitle(suptitle, fontsize=14, fontweight='bold')
ax.legend(loc=legend_location)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("bar_212.pdf", bbox_inches="tight")

