

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
months = ["Jan", "Feb", "Mar", "Apr"]
Company_A = [150, 155, 160, 170]
Company_B = [140, 145, 150, 155]
Company_C = [135, 140, 145, 150]
Company_D = [130, 135, 140, 145]

# X-axis positions for each group
x = np.arange(len(months))

# Labels and Titles
ylabel = "Stock Price ($)"
xlabel = "Months"
title = "Monthly Stock Prices of Companies"

# Legend labels
legend_labels = ["Company A", "Company B", "Company C", "Company D"]

# Axis limits
ylim = (120, 180)

# Axis tick labels
xticks = x
xticklabels = months

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Colors - A new color palette
colors = ["#6b5b95", "#feb236", "#d64161", "#ff7b25"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting bars
ax.bar(
    x - bar_width * 1.5,
    Company_A,
    width=bar_width,
    label=legend_labels[0],
    color=colors[0],
)
ax.bar(
    x - bar_width / 2,
    Company_B,
    width=bar_width,
    label=legend_labels[1],
    color=colors[1],
)
ax.bar(
    x + bar_width / 2,
    Company_C,
    width=bar_width,
    label=legend_labels[2],
    color=colors[2],
)
ax.bar(
    x + bar_width * 1.5,
    Company_D,
    width=bar_width,
    label=legend_labels[3],
    color=colors[3],
)

# Adding labels and title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Adding x-axis tick labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels, fontsize=10)

plt.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.15), frameon=False, ncol=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_213.pdf", bbox_inches="tight")

