

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
content_types = ["Text", "Image", "Video", "Live Stream"]
Facebook = [50, 70, 85, 90]
Instagram = [60, 80, 90, 95]
Twitter = [40, 60, 75, 80]
LinkedIn = [30, 50, 65, 70]

# X-axis positions for each group
x = np.arange(len(content_types))

# Labels and Titles
ylabel = "Engagement Score"
xlabel = "Content Type"
title = "Engagement on Social Media Platforms by Content Type"

# Legend labels
legend_labels = ["Facebook", "Instagram", "Twitter", "LinkedIn"]

# Axis limits
ylim = (0, 100)

# Axis tick labels
xticks = x
xticklabels = content_types

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Colors
colors = ["#99d98c", "#76c893", "#52b69a", "#34a0a4"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting bars
ax.bar(
    x - bar_width * 1.5,
    Facebook,
    width=bar_width,
    label=legend_labels[0],
    color=colors[0],
)
ax.bar(
    x - bar_width / 2,
    Instagram,
    width=bar_width,
    label=legend_labels[1],
    color=colors[1],
)
ax.bar(
    x + bar_width / 2,
    Twitter,
    width=bar_width,
    label=legend_labels[2],
    color=colors[2],
)
ax.bar(
    x + bar_width * 1.5,
    LinkedIn,
    width=bar_width,
    label=legend_labels[3],
    color=colors[3],
)

# Adding labels and title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Adding x-axis tick labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)

# Removing tick marks for cleaner look
plt.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.15), frameon=False, ncol=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_215.pdf", bbox_inches="tight")

