
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
categories = ["North Region", "South Region", "East Region", "West Region"]
wheat = [55, 65, 45, 75]
corn = [25, 20, 35, 15]
rice = [20, 15, 20, 10]

labels = ["Wheat", "Corn", "Rice"]
titles = [
    "Crop Distribution in North Region",
    "Crop Distribution in South Region",
    "Crop Distribution in East Region",
    "Crop Distribution in West Region",
]
xlabel = "Percentage of Crops"
ylabel = "Region"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axes = plt.subplots(2, 2, figsize=(13, 6))

# Function to create a bar chart
def create_bar_chart(ax, wheat, corn, rice, title):
    bar_width = 0.5
    indices = np.arange(len(categories))

    ax.barh(indices, wheat, bar_width, color="#f1c40f", label=labels[0])
    ax.barh(indices, corn, bar_width, left=wheat, color="#95a5a6", label=labels[1])
    ax.barh(indices, rice, bar_width, left=np.add(wheat, corn), color="#3498db", label=labels[2])

    ax.set_yticks(indices)
    ax.set_yticklabels(categories)
    ax.invert_yaxis()  # labels read top-to-bottom
    ax.set_title(title)
    ax.set_xlim(0, 100)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, which="both", linestyle='--', linewidth=0.5)

    for i, (w, c, r) in enumerate(zip(wheat, corn, rice)):
        ax.text(w / 2, i, f"{w}%", ha="center", va="center", color="black")
        ax.text(w + c / 2, i, f"{c}%", ha="center", va="center", color="black")
        ax.text(w + c + r / 2, i, f"{r}%", ha="center", va="center", color="black")

    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.set_yticklabels(categories, rotation=0)

# Create each bar chart
create_bar_chart(axes[0, 0], wheat, corn, rice, titles[0])
create_bar_chart(axes[1, 0], wheat, corn, rice, titles[1])
create_bar_chart(axes[0, 1], wheat, corn, rice, titles[2])
create_bar_chart(axes[1, 1], wheat, corn, rice, titles[3])

# Add a legend
handles, labels = axes[0, 0].get_legend_handles_labels()
fig.legend(handles, labels, loc="lower center", ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.05, 1, 1])
plt.savefig("bar_220.pdf", bbox_inches="tight")
