

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)  # Seed for reproducibility

# Data for the bar charts
regions = ["Region A", "Region B", "Region C", "Region D"]
party_A = [25, 40, 55, 35, 60, 50, 45, 30, 70, 20, 65, 50, 55, 60, 75, 40]
party_B = [45, 30, 25, 40, 20, 30, 35, 40, 10, 50, 25, 35, 20, 25, 15, 35]
party_C = [30, 30, 20, 25, 20, 20, 20, 30, 20, 30, 10, 15, 25, 15, 10, 25]

# Chart labels
labels = ["Party A", "Party B", "Party C"]

# Titles for the subplots
titles = [
    "Election Results (Region A)",
    "Election Results (Region B)",
    "Election Results (Region C)",
    "Election Results (Region D)",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axes = plt.subplots(2, 2, figsize=(13, 6))

# Function to create a bar chart
def create_bar_chart(ax, party_A, party_B, party_C, title):
    bar_width = 0.5
    indices = np.arange(len(regions))

    color_party_A = "#2e8b57"
    color_party_B = "#4682b4"
    color_party_C = "#cd5c5c"

    ax.barh(indices, party_A, bar_width, color=color_party_A, label=labels[0])
    ax.barh(indices, party_B, bar_width, left=party_A, color=color_party_B, label=labels[1])
    ax.barh(
        indices,
        party_C,
        bar_width,
        left=np.add(party_A, party_B),
        color=color_party_C,
        label=labels[2],
    )

    ax.set_yticks(indices)
    ax.set_yticklabels(regions)
    ax.invert_yaxis()  # labels read top-to-bottom
    ax.set_title(title)
    ax.set_xlim(0, 100)

    for i, (a, b, c) in enumerate(zip(party_A, party_B, party_C)):
        ax.text(a / 2, i, f"{a}%", ha="center", va="center", color="white")
        ax.text(a + b / 2, i, f"{b}%", ha="center", va="center", color="white")
        ax.text(a + b + c / 2, i, f"{c}%", ha="center", va="center", color="white")
        for spine in ax.spines.values():
            spine.set_visible(False)


# Create each bar chart
create_bar_chart(axes[0, 0], party_A[:4], party_B[:4], party_C[:4], titles[0])
create_bar_chart(axes[1, 0], party_A[4:8], party_B[4:8], party_C[4:8], titles[1])
create_bar_chart(axes[0, 1], party_A[8:12], party_B[8:12], party_C[8:12], titles[2])
create_bar_chart(axes[1, 1], party_A[12:], party_B[12:], party_C[12:], titles[3])

# Add a legend
handles, labels = axes[0, 0].get_legend_handles_labels()
fig.legend(handles, labels, loc="lower center", ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.05, 1, 1])
plt.savefig("bar_221.pdf", bbox_inches="tight")

