

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
decades = ["1990", "2000", "2010", "2020"]
digital_art_popularity = [15.0, 25.0, 35.0, 45.0]
traditional_art_popularity = [85.0, 75.0, 65.0, 55.0]
digital_art_popularity_scenario_b = [18.0, 28.0, 38.0, 48.0]
traditional_art_popularity_scenario_b = [82.0, 72.0, 62.0, 52.0]

labels = ["Digital Art", "Traditional Art"]

# X-axis positions
x = np.arange(len(decades))
indexs = [2, 4]

# Plot labels
scenario_a_title = "(a) Scenario A: Digital vs Traditional Art"
scenario_b_title = "(b) Scenario B: Digital vs Traditional Art"
ylabel_digital = "Digital Art Popularity (%)"
ylabel_traditional = "Traditional Art Popularity (%)"
yticks_digital = [10, 20, 30, 40, 50]
yticks_traditional = [50, 60, 70, 80, 90]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
colors = ["#2ca02c", "#1f77b4", "#ff7f0e", "#9467bd"]
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 8))

barwidth = 0.3
# Scenario A subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        digital_art_popularity[i],
        width=barwidth,
        label="Digital Art" if i == 0 else "",
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        traditional_art_popularity[i],
        width=barwidth,
        label="Traditional Art" if i == 0 else "",
        color=colors[i],
        hatch="/",
    )
ax1.set_title(scenario_a_title)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_digital)
ax1.set_yticks(yticks_digital)
ax1.tick_params(axis="both", which="both", length=0)
ax1.legend()

# Scenario B subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        digital_art_popularity_scenario_b[i],
        width=barwidth,
        label="Digital Art" if i == 0 else "",
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        traditional_art_popularity_scenario_b[i],
        width=barwidth,
        label="Traditional Art" if i == 0 else "",
        color=colors[i],
        hatch="/",
    )
ax2.set_title(scenario_b_title)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_traditional)
ax2.set_yticks(yticks_traditional)
ax2.tick_params(axis="both", which="both", length=0)
ax2.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_223.pdf", bbox_inches="tight")
