

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = ["2012", "2016", "2020", "2024"]
north_usage = [2.0, 2.5, 3.0, 3.5]
south_usage = [1.5, 2.0, 2.7, 3.2]
east_usage = [2.8, 3.1, 3.5, 4.0]
west_usage = [2.2, 2.5, 2.9, 3.3]

labels = ["North Usage", "South Usage", "East Usage", "West Usage"]
xlabel = "Years"
ylabel = "Social Media Usage (Hours per day)"
title = "Social Media Usage by Region Over Years"
yaxhline = 4.0
ylim = [0, 5]
yticks = np.arange(0, 6, 1)

# Positions of bars on x-axis
ind = np.arange(len(years))

texts = ["2.0h", "2.5h", "3.0h", "3.5h"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Figure size
plt.figure(figsize=(10, 7))

# Plotting
plt.bar(ind, north_usage, width=bar_width, label=labels[0], color="#4CAF50", hatch="//")
plt.bar(ind + bar_width, south_usage, width=bar_width, label=labels[1], color="#FF9800", hatch="\\")
plt.bar(ind + 2 * bar_width, east_usage, width=bar_width, label=labels[2], color="#2196F3", hatch="..")
plt.bar(ind + 3 * bar_width, west_usage, width=bar_width, label=labels[3], color="#9C27B0", hatch="xx")

# Annotating data points
for i in range(len(years)):
    plt.annotate(texts[i], 
                 xy=(ind[i], north_usage[i]), 
                 xytext=(ind[i], north_usage[i] + 0.2),
                 ha='center', va='bottom', fontsize=10, color='black')

plt.axhline(y=yaxhline, color="red", linestyle="--", linewidth=2)

# X-axis labels
plt.xticks(ind + 1.5 * bar_width, years)

# Y-axis labels
plt.ylim(ylim)
plt.yticks(yticks)

# Legend
plt.legend(loc="upper left")

# Grid lines
plt.grid(axis="y", linestyle='--', alpha=0.7)

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_225.pdf", bbox_inches="tight")

