
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Beach", "Mountain", "City"]
values1 = [90, 85, 80]
values2 = [70, 75, 65]
values3 = [80, 82, 78]
values4 = [75, 70, 72]
values5 = [95, 90, 88]

values1minus = [-10, -15, -20]
values2minus = [-25, -22, -28]
values3minus = [-18, -20, -22]
values4minus = [-20, -25, -23]
values5minus = [-15, -10, -12]

# Set up the bar width
barWidth = 0.15

# Set position of bar on X axis
r1 = np.arange(len(values1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["Cleanliness", "Accessibility", "Attractions", "Accommodation", "Safety"]
xlabel = "Tourist Destinations"
ylabel = "Ratings"
yticks = np.arange(-50, 101, 20)
title = "Tourist Destination Ratings Based on Criteria"
legendlabels = ["Cleanliness", "Accessibility", "Attractions", "Accommodation", "Safety"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
plt.figure(figsize=(10, 6))
plt.suptitle(title, fontsize=16, fontweight='bold')

# Color scheme from Coolors
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

# Make the plot
bars = []
bars.append(plt.bar(r1, values1, color=colors[0], width=barWidth, edgecolor="black", label=labels[0]))
bars.append(plt.bar(r2, values2, color=colors[1], width=barWidth, edgecolor="black", label=labels[1]))
bars.append(plt.bar(r3, values3, color=colors[2], width=barWidth, edgecolor="black", label=labels[2]))
bars.append(plt.bar(r4, values4, color=colors[3], width=barWidth, edgecolor="black", label=labels[3]))
bars.append(plt.bar(r5, values5, color=colors[4], width=barWidth, edgecolor="black", label=labels[4]))

# Minus values bars
bars.append(plt.bar(r1, values1minus, color=colors[0], width=barWidth, edgecolor="grey", label=labels[0], alpha=0.5))
bars.append(plt.bar(r2, values2minus, color=colors[1], width=barWidth, edgecolor="grey", label=labels[1], alpha=0.5))
bars.append(plt.bar(r3, values3minus, color=colors[2], width=barWidth, edgecolor="grey", label=labels[2], alpha=0.5))
bars.append(plt.bar(r4, values4minus, color=colors[3], width=barWidth, edgecolor="grey", label=labels[3], alpha=0.5))
bars.append(plt.bar(r5, values5minus, color=colors[4], width=barWidth, edgecolor="grey", label=labels[4], alpha=0.5))

# Add text on the top of each bar
for i in range(len(r1)):
    plt.text(r1[i], values1[i] - 1, str(values1[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r2[i], values2[i] - 1, str(values2[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r3[i], values3[i] - 1, str(values3[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r4[i], values4[i] - 1, str(values4[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r5[i], values5[i] - 1, str(values5[i]), ha="center", va="top", rotation=-90, fontsize=9)
    plt.text(r1[i], values1minus[i] + 1, str(-values1minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r2[i], values2minus[i] + 1, str(-values2minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r3[i], values3minus[i] + 1, str(-values3minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r4[i], values4minus[i] + 1, str(-values4minus[i]), ha="center", va="bottom", rotation=-90, fontsize=9)
    plt.text(r5[i], values5minus[i] - 1, str(-values5minus[i]), ha="center", va="top", rotation=-90, fontsize=9)

# Add xticks on the middle of the group bars
plt.xlabel(xlabel, fontsize=12)
plt.xticks([r + 2 * barWidth for r in range(len(values1))], categories, fontsize=10)
plt.yticks(yticks, fontsize=10)
plt.ylabel(ylabel, fontsize=12)
# Create legend & Show graphic
plt.legend(legendlabels, loc='upper left', bbox_to_anchor=(1,1), fontsize=9)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_229.pdf", bbox_inches="tight")
