
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
energy_sources = [
    "Coal",
    "Natural Gas",
    "Nuclear",
    "Hydro",
    "Wind",
    "Solar",
    "Geothermal",
    "Biomass",
    "Oil",
    "Waste",
]
number_of_power_plants = [1200, 1600, 450, 800, 950, 600, 75, 150, 500, 100]

# Axes Limits and Labels
xlabel_value = "Number of Power Plants"
title = "Number of Power Plants by Energy Source"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match original image's dimensions
plt.barh(energy_sources, number_of_power_plants, color=['#FF6F61', '#6B5B95', '#88B04B', '#FFA07A', '#FFD700', '#40E0D0', '#9B870C', '#FF6347', '#87CEEB', '#FF4500'])  # Nice new colors
plt.xlabel(xlabel_value)
plt.title(title)

# Add data labels
for index, value in enumerate(number_of_power_plants):
    plt.text(
        value + 10, index, str(value), va="center", fontsize=10
    )  # Adjust text position and font size

plt.yticks(rotation=0)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_231.pdf", bbox_inches="tight")
