

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Eiffel Tower", "Great Wall", "Colosseum", "Machu Picchu", "Taj Mahal", "Statue of Liberty", "Christ the Redeemer"]
tourist_data = [4000, 8000, 12000, 6000, 9000, 14000, 7000]
local_data = [-2400, -2000, -4000, -3000, -3500, -4500, -2500]
labels = ["Number of Tourists", "Number of Locals"]
xlabel = "Number of Visitors"
title = "Tourist vs Local Visits to Popular Tourist Spots"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # 576x432 pixels
colors_tourist = ["#FF6347", "#FF4500", "#FFA07A", "#FF7F50", "#FFA500", "#FF8C00", "#FF8243"]
colors_local = ["#ADD8E6", "#87CEEB", "#00BFFF", "#1E90FF", "#4169E1", "#4682B4", "#5F9EA0"]

# Plot horizontal bar chart
ax.barh(categories, local_data, color=colors_local, edgecolor="black", label=labels[1])
ax.barh(categories, tourist_data, left=0, color=colors_tourist, edgecolor="black", label=labels[0])

# Add data labels
for i, (loc_val, tour_val) in enumerate(zip(local_data, tourist_data)):
    ax.text(loc_val, i, f"{loc_val}", va="center", ha="right", color="black")
    ax.text(tour_val, i, f"{tour_val}", va="center", ha="left", color="black")

# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Set x-axis limits and labels
ax.set_xlim(min(local_data) - 2000, max(tourist_data) + 2000)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Hide left and right spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add legend
ax.legend(loc="upper right")

# Invert y-axis
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_235.pdf", bbox_inches="tight")
