
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
    "Dallas",
    "San Jose"
]
observed_temperatures = [5.3, 15.2, 6.5, 16.7, 19.8, 11.4, 18.1, 17.5, 15.1, 14.8]
predicted_temperatures = [5.5, 14.9, 6.3, 16.5, 20.0, 11.2, 18.3, 17.7, 15.3, 15.0]

x = np.arange(len(cities))  # the label locations
labels = ["Observed Temperature", "Predicted Temperature"]
ylabel = "Average Temperature (°C)"
title = "Average Monthly Temperatures in Various Cities"
xlabel = "City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(
    figsize=(12, 7)
)  # Adjust the figure size to match the general visual quality

# Create the bars
for i in range(len(cities)):
    ax.bar(
        x[i],
        observed_temperatures[i],
        color="#5F9EA0",  # Teal color
        label=labels[0] if i == 0 else "",
        hatch="///",
        edgecolor="black",
    )
    ax.bar(
        x[i],
        predicted_temperatures[i],
        bottom=observed_temperatures[i],
        color="#FF7F50",  # Coral color
        label=labels[1] if i == 0 else "",
        alpha=0.75,
        hatch="..",
        edgecolor="black",
    )

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(cities, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("bar_238.pdf", bbox_inches="tight")
