
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
historical_events = [
    "Industrial Revolution", "World War I", "World War II", "Moon Landing", 
    "Fall of Berlin Wall", "Invention of the Internet", "9/11 Attacks", 
    "COVID-19 Pandemic", "American Independence", "French Revolution", 
    "Russian Revolution", "Renaissance", "Martin Luther King's Speech", 
    "Discovery of America", "First Flight", "Fall of Roman Empire", 
    "Invention of Printing Press", "Great Depression", "Signing of Magna Carta"
]
historian_distribution = [
    0.15, 0.1, 0.12, 0.05, 0.08, 0.1, 0.07, 0.08, 0.1, 0.06, 
    0.05, 0.05, 0.06, 0.04, 0.03, 0.07, 0.05, 0.1, 0.04
]
public_distribution = [
    0.1, 0.08, 0.12, 0.09, 0.07, 0.08, 0.1, 0.1, 0.05, 0.05, 
    0.04, 0.03, 0.06, 0.05, 0.05, 0.04, 0.06, 0.1, 0.04
]

x = np.arange(len(historical_events))  # the label locations
labels = ["Historians' View", "Public View"]
ylabel = "Perceived Importance"
title = "Perception of Historical Events"
xlabel = "Historical Events"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))  # Adjust the figure size to match the original image's dimensions

# Create the bars
for i in range(len(historical_events)):
    ax.bar(
        x[i],
        historian_distribution[i],
        color="#8B0000",  # Dark Red for historian distribution
        label=labels[0] if i == 0 else "",
        hatch="///",
        edgecolor="black"
    )
    ax.bar(
        x[i],
        public_distribution[i],
        bottom=historian_distribution[i],
        color="#4682B4",  # Steel Blue for public distribution
        label=labels[1] if i == 0 else "",
        alpha=0.7,
        hatch="..",
        edgecolor="black"
    )

# Add some text for labels, title, and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(historical_events, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("bar_239.pdf", bbox_inches="tight")
