

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.cm as cm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
temperatures = [13, 19, 11, 21, 23]  # Average temperatures in Celsius.
title = "Average Monthly Temperatures of Cities"
xlabel = "Temperature (°C)"
ylabel = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create color map
colors = cm.autumn(np.linspace(0, 1, len(temperatures)))
# Create horizontal bar chart
plt.figure(figsize=(8, 4))
plt.barh(cities, temperatures, color=colors)

# Adding title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)

# Remove the spines and add gridlines
for spine in plt.gca().spines.values():
    spine.set_visible(False)
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_241.pdf", bbox_inches="tight")

