

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Health and Fitness Activities categories
categories = [
    "Yoga",
    "Running",
    "Cycling",
    "Weightlifting",
    "Swimming",
    "Pilates",
    "Aerobics",
    "Hiking",
    "Dancing",
    "Meditation",
]

# Approximate frequency values based on a plausible distribution
frequencies = [14.5, 18.0, 12.0, 10.8, 9.5, 7.2, 6.3, 8.1, 5.0, 8.6]
xlabel = "Frequency (%)"
ylabel = "Activity Type"
title = "Health and Fitness Activity Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
colors = plt.cm.viridis(np.linspace(0, 1, len(frequencies)))  # Use a colormap
plt.barh(categories, frequencies, color=colors, edgecolor="black", alpha=0.7)

# Adding data labels
for index, value in enumerate(frequencies):
    plt.text(value, index, f" {value}%", va="center", color='black', fontweight='bold')

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_245.pdf", bbox_inches="tight")
