
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# IT Employment Data Example
categories = [
    "Software Engineers",
    "Data Scientists",
    "System Administrators",
    "Cybersecurity Experts",
    "Product Managers",
    "UX/UI Designers",
    "DevOps Engineers",
][::-1]
north_america_data = [250, 150, 100, 120, 90, 80, 200][::-1]
europe_data = [180, 130, 80, 110, 70, 60, 150][::-1]
asia_data = [300, 200, 150, 220, 140, 120, 400][::-1]
africa_data = [100, 70, 50, 60, 40, 35, 90][::-1]
south_america_data = [80, 60, 40, 50, 30, 25, 70][::-1]
labels = ["North America", "Europe", "Asia", "Africa", "South America"]

# Labels and Titles
xlabel = "Number of Employees (in thousands)"
ylabel = "Job Roles"
title = "IT Employment Distribution by Region"
supertitle = "Tech Industry Job Market Analysis"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(
    figsize=(10, 6)
)
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(y_pos, north_america_data, bar_width, color="#ff9999", label=labels[0])
ax.barh(y_pos, europe_data, bar_width, left=north_america_data, color="#66b3ff", label=labels[1])
ax.barh(
    y_pos,
    asia_data,
    bar_width,
    left=[i + j for i, j in zip(north_america_data, europe_data)],
    color="#99ff99",
    label=labels[2],
)
ax.barh(
    y_pos,
    africa_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(north_america_data, europe_data, asia_data)],
    color="#ffcc99",
    label=labels[3],
)
ax.barh(
    y_pos,
    south_america_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(north_america_data, europe_data, asia_data, africa_data)
    ],
    color="#c2c2f0",
    label=labels[4],
)

# Labels and Legend
ax.set_xticks(np.arange(0, 801, 100))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_250.pdf", bbox_inches="tight")
