

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensure reproducibility
# Religion Data Example
categories = [
    "Religiosity Index",
    "Attendance of Religious Services",
    "Belief in Higher Power",
    "Daily Prayer Practice",
    "Reading of Religious Texts",
    "Participation in Religious Community",
    "Religious Education"
][::-1]

us_data = [6.8, 4.5, 7.2, 5.9, 6.1, 5.6, 4.8][::-1]
eu_data = [5.5, 3.8, 6.0, 4.2, 5.0, 4.5, 3.5][::-1]
china_data = [3.0, 1.0, 2.5, 1.5, 2.0, 1.8, 1.2][::-1]
india_data = [8.5, 7.8, 8.2, 7.5, 7.8, 7.2, 8.0][::-1]
brazil_data = [7.1, 6.0, 6.8, 6.0, 6.5, 6.2, 5.9][::-1]
labels = ["US", "EU", "China", "India", "Brazil"]

xlabel = "Index Value"
ylabel = "Religious Metrics"
title = "Religious Metrics Across Different Regions"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))

bar_width = 0.5
y_pos = range(len(categories))

ax.barh(y_pos, us_data, bar_width, color="#4E79A7", label=labels[0])
ax.barh(y_pos, eu_data, bar_width, left=us_data, color="#F28E2B", label=labels[1])
ax.barh(
    y_pos,
    china_data,
    bar_width,
    left=[i + j for i, j in zip(us_data, eu_data)],
    color="#E15759",
    label=labels[2],
)
ax.barh(
    y_pos,
    india_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(us_data, eu_data, china_data)],
    color="#76B7B2",
    label=labels[3],
)
ax.barh(
    y_pos,
    brazil_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(us_data, eu_data, china_data, india_data)
    ],
    color="#59A14F",
    label=labels[4],
)

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks(np.arange(0, 35, 5))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncols=3)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_251.pdf", bbox_inches="tight")

