
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
# Set the seed for reproducibility
import numpy as np
np.random.seed(0)

# Data
categories = [
    "Infectious Diseases",
    "Chronic Diseases",
    "Accidents",
    "Mental Health Issues",
    "Nutritional Deficiencies",
    "Cancer",
    "Respiratory Diseases",
    "Cardiovascular Diseases"
]
differences = np.random.randint(-40, 41, len(categories))
title = "Projected Change in Causes of Morbidity Over a Decade"
xlabel = "Change in Prevalence (%)"
ylabel = "Cause of Morbidity"
xlim = [-50, 50]
xticks = range(-50, 51, 10)
cbarlabels = ["Decrease in Prevalence", "Increase in Prevalence"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    (
        plt.cm.Blues(np.array(i) / min(differences))
        if i < 0
        else plt.cm.Greens(np.array(i) / max(differences))
    )
    for i in differences
]

# Create figure and plot
fig, ax = plt.subplots(figsize=(10, 6))
ax.barh(categories, differences, color=colors)

# Set title and labels
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set x-axis limits and labels
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.xaxis.grid(True, linestyle='--', linewidth=0.5, color='gray')

# Create colorbars
cbar1 = plt.colorbar(
    plt.cm.ScalarMappable(norm=mcolors.Normalize(0, 30), cmap="Blues"),
    ax=ax,
    orientation="vertical",
    pad=0.01,
    aspect=20,
)
cbar2 = plt.colorbar(
    plt.cm.ScalarMappable(norm=mcolors.Normalize(0, 30), cmap="Greens"),
    ax=ax,
    orientation="vertical",
    pad=0.01,
    aspect=20,
)
cbar1.set_label(cbarlabels[0], fontsize=10)
cbar2.set_label(cbarlabels[1], fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the figure
plt.savefig("bar_255.pdf", bbox_inches="tight")
