
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots
countries = ["Country A", "Country B", "Country C", "Country D", "Country E"]
population_growth_rates = [1.2, -0.5, 2.6, -1.8, 0.7]

# Axes Limits and Labels
ax_title = "Population Growth Rates of Different Countries in the Past Year"
xticks_values = range(-3, 4, 1)
xlabel = "Population Growth Rate (%)"
ylabel = "Countries"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Plot for Efficiency Improvement
bars = ax.barh(countries, population_growth_rates, color="lightblue", edgecolor="darkblue")
for bar, value in zip(bars, population_growth_rates):
    if value < 0:
        bar.set_hatch("..")
        bar.set_edgecolor("darkred")
ax.set_title(ax_title)
for i, v in enumerate(population_growth_rates):
    ax.text(
        v - 0.3 if v < 0 else v + 0.3,
        i,
        f"{v}%",
        color="darkblue" if v > 0 else "darkred",
        va="center",
        ha="right" if v < 0 else "left",
        fontsize=10,
        fontweight='bold'
    )
# Add a vertical line at x=0
ax.axvline(0, color="black")
ax.set_xticks(xticks_values)
# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Hide all axes except the bottom one
for spine in ["left", "right", "top"]:
    ax.spines[spine].set_visible(False)

# Add x-axis label
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_259.pdf", bbox_inches="tight")
