

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["Temperature", "Rainfall", "Sunshine Hours", "Days with Storms"]
temperature = [15, 20, 25, 12]  # Example data in degrees Celsius
rainfall = [100, 150, 120, 140]  # Example data in millimeters
sunshine_hours = [200, 250, 220, 180]  # Example data in hours
days_with_storms = [5, 8, 4, 6]  # Example data in days
labels = [
    "Temperature (°C)",
    "Rainfall (mm)",
    "Sunshine Hours (Hours)",
    "Days with Storms (Days)",
]
xticks = np.arange(0, 500, 50)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(
    y_pos,
    temperature,
    bar_width,
    color="#1f77b4",
    edgecolor="#2a3b4d",
    hatch="x",
    label=labels[0],
)
ax.barh(
    y_pos,
    rainfall,
    bar_width,
    left=temperature,
    color="#ff7f0e",
    edgecolor="#2a3b4d",
    hatch="o",
    label=labels[1],
)
ax.barh(
    y_pos,
    sunshine_hours,
    bar_width,
    left=[i + j for i, j in zip(temperature, rainfall)],
    color="#2ca02c",
    edgecolor="#2a3b4d",
    hatch=".",
    label=labels[2],
)
ax.barh(
    y_pos,
    days_with_storms,
    bar_width,
    left=[i + j + k for i, j, k in zip(temperature, rainfall, sunshine_hours)],
    color="#d62728",
    edgecolor="#2a3b4d",
    hatch="/" ,
    label=labels[3],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_261.pdf", bbox_inches="tight")
