
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = [
    "Running",
    "Cycling",
    "Swimming",
]
year_1 = [300, 400, 350]  # Number of participants in Year 1
year_2 = [450, 500, 420]  # Number of participants in Year 2
year_3 = [500, 600, 480]  # Number of participants in Year 3
labels = [
    "Year 1",
    "Year 2",
    "Year 3",
]
xticks = np.arange(0, 1600, 200)
xlabel = 'Number of Participants'
ylabel = 'Exercise Types'
title = 'Health and Fitness Activity Participation Over 3 Years'
legend_labels = ['Year 1', 'Year 2', 'Year 3']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(
    y_pos,
    year_1,
    bar_width,
    color="#4c72b0",
    edgecolor="#f7f7f7",
    hatch="*",
    label=legend_labels[0],
)
ax.barh(
    y_pos,
    year_2,
    bar_width,
    left=year_1,
    color="#dd8452",
    edgecolor="#f7f7f7",
    hatch="+",
    label=legend_labels[1],
)
ax.barh(
    y_pos,
    year_3,
    bar_width,
    left=[i + j for i, j in zip(year_1, year_2)],
    color="#55a868",
    edgecolor="#f7f7f7",
    hatch="/",
    label=legend_labels[2],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_yticklabels(categories)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_262.pdf", bbox_inches="tight")
