

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = [
    "City A",
    "City B",
    "City C",
    "City D",
]
average_annual_rainfall = [800, 1200, 500, 700]  # Example data in mm
average_annual_snowfall = [200, 100, 300, 150]  # Example data in mm
average_annual_sunny_days = [200, 180, 220, 210]  # Example data in days
labels = [
    "Average Annual Rainfall (mm)",
    "Average Annual Snowfall (mm)",
    "Average Annual Sunny Days",
]
xticks = np.arange(0, 1600, 200)
xlabel = "Counts"
title = "Weather Statistics of Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))
rainfall_color = "#4caf50"
snowfall_color = "#2196f3"
sunny_days_color = "#ff9800"
edge_color = "#2a3b4d"

ax.barh(
    y_pos,
    average_annual_rainfall,
    bar_width,
    color=rainfall_color,
    edgecolor=edge_color,
    hatch="o",
    label=labels[0],
)
ax.barh(
    y_pos,
    average_annual_snowfall,
    bar_width,
    left=average_annual_rainfall,
    color=snowfall_color,
    edgecolor=edge_color,
    hatch="x",
    label=labels[1],
)
ax.barh(
    y_pos,
    average_annual_sunny_days,
    bar_width,
    left=[i + j for i, j in zip(average_annual_rainfall, average_annual_snowfall)],
    color=sunny_days_color,
    edgecolor=edge_color,
    hatch="/",
    label=labels[2],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_263.pdf", bbox_inches="tight")
