
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "Criminal Law",
    "Family Law",
    "Corporate Law",
    "Intellectual Property",
    "Environmental Law",
    "Labor Law",
    "Immigration Law",
]
small_firms_data = [-25, -35, -15, -20, -10, -30, -22]
large_firms_data = [55, 65, 50, 40, 30, 60, 45]

# Labels and text
chart_title = "Comparison of Legal Cases Between Small and Large Firms"
x_label = "Number of Cases"
labels = ["Small Firms", "Large Firms"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 8))

# Define base colors
base_colors = [
    "#76c7c0",
    "#ff6f61",
    "#6b5b95",
    "#88b04b",
    "#f7cac9",
    "#92a8d1",
    "#f4a582",
]

# Generate colors with different saturation
colors_large_firms = base_colors
colors_small_firms = [mcolors.to_rgba(color, alpha=0.6) for color in base_colors]

# Plot horizontal bar chart
ax.barh(categories, small_firms_data, color=colors_small_firms, label=labels[0])
ax.barh(categories, large_firms_data, left=0, color=colors_large_firms, label=labels[1])

# Add data labels inside the bars
for i, (small_val, large_val) in enumerate(zip(small_firms_data, large_firms_data)):
    ax.text(small_val / 2, i, f"{abs(small_val)}", va="center", ha="center", color="white")
    ax.text(large_val / 2, i, f"{large_val}", va="center", ha="center", color="white")

# Configuration for axes and labels
ax.set_xlim(min(small_firms_data) - 10, max(large_firms_data) + 10)
ax.set_xlabel(x_label, fontsize=12,labelpad=20)
ax.set_title(chart_title, fontsize=14, pad=20)
ax.set_xticks([])
ax.tick_params(axis="y", which="both", left=False)
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add text to x=0
ax.text(-4, len(categories), labels[0], ha="right", va="bottom", fontsize=10)
ax.text(4, len(categories), labels[1], ha="left", va="bottom", fontsize=10)

# Invert y-axis
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()

# Save the figure
plt.savefig("bar_264.pdf", bbox_inches="tight")
