
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for psychology test scores
departments = ["Group A", "Group B", "Group C", "Group D"]
cognitive_scores = np.array([75, 82, 78, 85]) + np.random.rand(4) * 5  # Cognitive test scores
behavioral_scores = np.array([70, 77, 75, 80]) + np.random.rand(4) * 5  # Behavioral test scores
emotional_scores = np.array([65, 70, 68, 72]) + np.random.rand(4) * 5  # Emotional test scores
social_scores = np.array([60, 65, 63, 68]) + np.random.rand(4) * 5  # Social test scores

labels = ["Cognitive", "Behavioral", "Emotional", "Social"]
xlabel = "Average Scores"
ylabel = "Groups"
title = "Average Scores by Psychological Test and Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(cognitive_scores)) * 1.5  # Increase space between groups

# Define some hatch patterns and colors to use for bars
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#4daf4a", "#377eb8", "#ff7f00", "#984ea3"]

# Plot bars for each test's average scores
for i, scores in enumerate([cognitive_scores, behavioral_scores, emotional_scores, social_scores]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        scores,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis Labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(cognitive_scores), np.max(behavioral_scores), np.max(emotional_scores), np.max(social_scores))
    + 10,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], departments)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_271.pdf", bbox_inches="tight")
