

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Media consumption metrics across regions
regions = ["North", "South", "East", "West"]
screen_time = np.array([5, 6, 4, 7]) + np.random.rand(4)  # Average screen time in hours per day
social_media = np.array([2, 3, 1.5, 2.5]) + np.random.rand(4)  # Social media usage in hours per day
streaming_time = np.array([3, 4, 2.5, 3.5]) + np.random.rand(4)  # Streaming service time in hours per day
reading_time = np.array([1, 1.5, 0.5, 2]) + np.random.rand(4)  # Reading time in hours per day

labels = ["Screen Time (hrs/day)", "Social Media (hrs/day)", "Streaming Time (hrs/day)", "Reading Time (hrs/day)"]
xlabel = "Metrics"
ylabel = "Regions"
title = "Media Consumption Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(screen_time)) * 1.5  # Increase space between groups

# Define new color palette and hatch patterns for technology theme
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot bars for each performance metric
for i, level in enumerate([screen_time, social_media, streaming_time, reading_time]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        level,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(screen_time), np.max(social_media), np.max(streaming_time), np.max(reading_time))
    + 1,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], regions)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_272.pdf", bbox_inches="tight")

