

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import colorsys

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Redefining the data for crop production
crops = ["Wheat", "Corn", "Rice", "Barley", "Soybeans", "Oats", "Sorghum"]
production_percentages = [35.5, 28.3, 18.2, 12.0, 25.1, 9.7, 5.2]  # in percentages

# Sorting the data in descending order while keeping track of the crops order
sorted_data = sorted(zip(production_percentages, crops), reverse=True)
sorted_production_percentages, sorted_crops = zip(*sorted_data)

title = "Crop Production Distribution in Region X"
xlabel = "Crop"
ylabel = "Percentage of Total Production (%)"
ylim = [0, np.max(sorted_production_percentages) + 10]

# Generate random colors with lower saturation
def hsl_to_rgb(h, s, l):
    return colorsys.hls_to_rgb(h, l, s)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart with the sorted data
plt.figure(figsize=(12, 8))
# Randomly generate colors
colors = [hsl_to_rgb(hue, 0.5, 0.6) for hue in np.linspace(0, 1, len(crops) + 1)[:-1]]

bars = plt.bar(sorted_crops, sorted_production_percentages, color=colors)

# Adding data labels to each bar
for bar in bars:
    yval = bar.get_height()
    text_y = yval - 5 if yval > 10 else yval + 1  # Slight modification to avoid negative values
    plt.text(bar.get_x() + bar.get_width() / 2, text_y, f"{yval}%", ha="center", va="top" if text_y < yval else "bottom")

# Set chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Randomly set y-axis range to a bit higher than the max value
plt.ylim(ylim)

# Randomize the gridlines and ticks
plt.grid(axis="y", linestyle="--", alpha=0.7)

# Randomize tick rotation
plt.xticks(rotation=45)

# Hide the top and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Apply tight layout
plt.tight_layout()

plt.savefig("bar_279.pdf", bbox_inches="tight")
