
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import colorsys

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Redefining the data
transport_modes = ["Subway", "Bus", "Bicycle", "Taxi", "Tram", "Ferry", "Car"]
average_daily_passengers = [1500, 1200, 300, 800, 400, 200, 1800]

# Sorting the data in descending order while keeping track of the transport modes order
sorted_data = sorted(zip(average_daily_passengers, transport_modes), reverse=True)
sorted_average_daily_passengers, sorted_transport_modes = zip(*sorted_data)

title = "Average Daily Passengers by Transportation Mode"
xlabel = "Transportation Mode"
ylabel = "Average Daily Passengers"
ylim = [0, np.max(sorted_average_daily_passengers) + 200]

# Generate random colors with lower saturation
def hsl_to_rgb(h, s, l):
    return colorsys.hls_to_rgb(h, l, s)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and bar chart with the sorted data
plt.figure(figsize=(12, 8))
# Randomly generate colors
colors = [hsl_to_rgb(hue, 0.5, 0.6) for hue in np.linspace(0, 1, len(transport_modes) + 1)[:-1]]

bars = plt.bar(sorted_transport_modes, sorted_average_daily_passengers, color=colors)

# Add text labels on bars
for bar in bars:
    yval = bar.get_height()
    text_y = (
        yval - 30 if yval > 100 else yval + 20
    )  # Slight modification to avoid negative values
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        text_y,
        f"{yval}",
        ha="center",
        va="top" if text_y < yval else "bottom",
    )

# Set chart title and labels
plt.title(title, fontsize=16)
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)

# Set y-axis range
plt.ylim(ylim)

# Add gridlines
plt.grid(axis="y", linestyle="--", alpha=0.7)

# Rotate x-axis labels
plt.xticks(rotation=45, fontsize=12)
plt.yticks(fontsize=12)

# Hide the top and right spines
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Apply tight layout
plt.tight_layout()

plt.savefig("bar_280.pdf", bbox_inches="tight")
