

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example historical data
categories = [
    "15th Century",
    "16th Century",
    "17th Century",
    "18th Century",
    "19th Century",
    "20th Century",
    "21st Century",
    "22nd Century",
]
layer_data = {
    "Wars": np.array([15, 20, 25, 30, 35, 40, 10, 5]),
    "Discoveries": np.array([5, 15, 10, 20, 25, 35, 30, 40]),
    "Treatises": np.array([10, 5, 15, 10, 20, 25, 10, 15]),
    "Movements": np.array([20, 25, 30, 15, 25, 30, 20, 10]),
}

title = "Stacked Bar Chart of Notable Historical Events"
xlabel = "Centuries"
ylabel = "Number of Events"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Colors for each layer (Wars: Yellow, Discoveries: Green, Treatises: Blue, Movements: Gray)
colors = ["#ffdd57", "#7ac943", "#00a1e4", "#4d4d4d"]

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(12, 7))

# Variables to store the bottom position for each stack
bottoms = np.array([0] * len(categories))

for i, (layer, values) in enumerate(layer_data.items()):
    bars = ax.bar(categories, values, bottom=bottoms, color=colors[i], label=layer)

    # Add data labels on each bar
    for bar, bottom in zip(bars, bottoms):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bottom + height / 2,
            str(height),
            ha="center",
            va="center",
            color="white",
        )

    # Update the bottoms position
    bottoms += values

# Chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot as PDF
plt.savefig("bar_283.pdf", bbox_inches="tight")
