
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for art domain
annotators = ["Critic 1", "Critic 2", "Critic 3", "Critic 4", "Critic 5", "Critic 6"]
scores = {
    "Critic 1": [75, 85, 95, 90, 80],
    "Critic 2": [88, 92, 78, 85, 90],
    "Critic 3": [80, 90, 100, 95, 85],
    "Critic 4": [85, 89, 91, 92, 88],
    "Critic 5": [90, 80, 85, 88, 92],
    "Critic 6": [77, 86, 82, 91, 89],
}

title = "Art Piece Review Scores by Various Critics"
xlabel = "Critic"
ylabel = "Scores"
ylim = [0, 450]
yticks = range(0, 451, 50)
score_labels = [f"Art Piece {i+1}" for i in range(5)]
legendtitle = "Art Pieces"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("cool")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, annotator in enumerate(annotators):
    bottom = 0
    score_list = scores[annotator]
    for j, score in enumerate(score_list):
        color = cmap(
            1 - j / len(score_list)
        )  # Determine color based on position in list
        bar = ax.bar(annotator, score, bottom=bottom, color=color)
        bottom += score
        # Annotate each segment
        if j == len(score_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title, fontsize=15, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with score indications
ax.legend(score_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left", fontsize=10, title_fontsize='13')
ax.yaxis.grid(linestyle="--", color='gray')

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_288.pdf", bbox_inches="tight")
