
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data
courses = ["Course A", "Course B", "Course C", "Course D", "Course E", "Course F"]
enrollments = {
    "Course A": [320, 410, 380, 425, 390],
    "Course B": [240, 330, 350, 370, 420],
    "Course C": [280, 380, 320, 430, 310],
    "Course D": [300, 270, 340, 310, 290],
    "Course E": [350, 310, 410, 380, 420],
    "Course F": [290, 240, 330, 315, 280],
}

title = "Online Course Enrollment Data (2023)"
xlabel = "Courses"
ylabel = "Number of Enrollments"
ylim = [0, 2000]
yticks = range(0, 2100, 400)
enrollment_labels = ["January", "February", "March", "April", "May"]
legendtitle = "Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("coolwarm")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, course in enumerate(courses):
    bottom = 0
    enrollment_list = enrollments[course]
    for j, enrollment in enumerate(enrollment_list):
        color = cmap(j / len(enrollment_list))  # Determine color based on position in list
        bar = ax.bar(course, enrollment, bottom=bottom, color=color)
        bottom += enrollment
        # Annotate each segment
        if j == len(enrollment_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - enrollment / 2,
                str(enrollment),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - enrollment / 2,
                str(enrollment),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with month indications
ax.legend(enrollment_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left")
ax.yaxis.grid(linestyle="--", color="gray", alpha=0.7)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_289.pdf", bbox_inches="tight")
