

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Data
law_firms = ["Law Firm A", "Law Firm B", "Law Firm C", "Law Firm D", "Law Firm E"]
performance_metrics = {"Client Satisfaction": [85.0], "Case Win Rate": [65.0], "Average Case Duration (months)": [8.0], "Client Retention Rate": [52.0], "Market Share Increase": [5.0]}

xlabel = "Law Firms"
ylabel = "Performance Metrics"
ylim = [0, 100]
legendtitle = "Metrics"
title = "Performance of Law Firms in Various Legal Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each metric
colors = ["#2E8B57", "#4682B4", "#3CB371", "#20B2AA", "#2E8B57"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(law_firms))

# Plotting the bars
for i, metric in enumerate(performance_metrics):
    bars = plt.bar(
        r[i],
        performance_metrics[metric],
        color=colors[i],
        width=bar_width,
        label=metric,
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, performance_metrics[metric]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 2 if height > 0 else height - 4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, law_firms, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

# Grid settings
plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper right")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_296.pdf", bbox_inches="tight")

