

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data
categories = ["Agriculture", "Manufacturing", "Services"]
methods = ["GDP Growth", "Inflation Rate", "Unemployment Rate", "Interest Rate", "Trade Balance"]
scores = [
    [2, 3.5, 4.1],
    [1.8, 2.2, 2.5],
    [6.5, 7.0, 7.3],
    [1.5, 1.2, 1.0],
    [0.3, 0.4, 0.6],
]

neg_scores = [
    [-0.5, -0.3, -0.4],
    [-0.2, -0.4, -0.3],
    [-1.0, -1.2, -1.5],
    [-0.2, -0.3, -0.1],
    [-0.1, -0.2, -0.3],
]

xlabel = "Economic Indicators"
yticks = np.arange(-2, 8, 1)
ylabel = "Percent Change"
legendtitle = "Sectors"

# Styling Texts
title = "Economic Performance Metrics by Sector"
suptitle = "Economic Indicators Data"
annotation_text = "Data reviewed in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4E79A7", "#F28E2C", "#E15759", "#76B7B2", "#59A14F"]

plt.figure(figsize=(12, 6))
barWidth = 0.15
positions = np.arange(len(methods))

for i, category in enumerate(categories):
    pos = [x + barWidth * i for x in positions]
    plt.bar(
        pos,
        [v[i] for v in scores],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        label=category,
    )
    plt.bar(
        pos,
        [v[i] for v in neg_scores],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        alpha=0.5,
    )

    for idx, val in enumerate(pos):
        plt.text(
            val,
            scores[idx][i] - 0.2,
            f"{scores[idx][i]}",
            ha="center",
            va="top",
            rotation=-90,
        )
        plt.text(
            val,
            neg_scores[idx][i] + 0.1,
            f"{-neg_scores[idx][i]}",
            ha="center",
            va="bottom",
            rotation=-90,
        )

plt.xlabel(xlabel)
plt.xticks([r + barWidth for r in range(len(methods))], methods)
plt.yticks(yticks)
plt.ylabel(ylabel)
plt.legend(title=legendtitle, loc='upper right')
plt.title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)
plt.annotate(annotation_text, (0, 1), (0, -20), fontsize=10, 
             xycoords='axes fraction', textcoords='offset points', va='top')

plt.tight_layout()
plt.savefig("bar_301.pdf", bbox_inches="tight")

