
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Product A", "Product B", "Product C"]
# Example Finance Dataset: Monthly Sales Data (in thousands of $)
values1 = [50, 60, 55]
values2 = [60, 55, 50]
values3 = [55, 50, 45]
values4 = [70, 60, 55]
values5 = [65, 70, 60]

# Example Negative Values: Monthly Costs Data (in thousands of $)
values1minus = [-30, -35, -32]
values2minus = [-35, -33, -30]
values3minus = [-32, -30, -28]
values4minus = [-40, -35, -32]
values5minus = [-38, -40, -35]

values = [values1, values2, values3, values4, values5]
values_minus = [values1minus, values2minus, values3minus, values4minus, values5minus]
labels = ["January", "February", "March", "April", "May"]
xlabel = "Months"
yticks = np.arange(-50, 101, 10)
ylabel = "Amount (in thousands of $)"
legendtitle = "Products"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#a6cee3", "#1f78b4", "#b2df8a", "#33a02c", "#fb9a99"]
# Set up the figure size
plt.figure(figsize=(10, 5))

# Set up the bar width
barWidth = 0.2

# Set up positions for the bars
positions = np.arange(len(labels))

# Creating bars for each category
for i, category in enumerate(categories):
    pos = [x + barWidth * i for x in positions]  # shift each bar by `barWidth * i`
    plt.bar(
        pos,
        [v[i] for v in values],
        color=colors[i],
        width=barWidth,
        edgecolor="black",
        label=category,
    )
    plt.bar(
        pos,
        [v[i] for v in values_minus],
        color=colors[i],
        width=barWidth,
        edgecolor="black",
        alpha=0.5,
        hatch='//'
    )

    # Add text on top and bottom of the bars
    for idx, val in enumerate(pos):
        plt.text(
            val,
            values[idx][i] - 1,
            f"{values[idx][i]}",
            ha="center",
            va="top",
            rotation=0,
        )
        plt.text(
            val,
            values_minus[idx][i] + 1,
            f"{-values_minus[idx][i]}",
            ha="center",
            va="bottom",
            rotation=0,
        )

# Adding axis labels and ticks
plt.xlabel(xlabel)
plt.xticks([r + barWidth * 1.0 for r in range(len(labels))], labels)
plt.yticks(yticks)

# Add a legend and display the plot
plt.ylabel(ylabel)
plt.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_302.pdf", bbox_inches="tight")

