

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for the bar charts
region_a_tourists = [45.2, 78.5, 85.3, 32.1]  # in thousands
region_b_tourists = [50.1, 65.0, 90.4, 25.8]  # in thousands
x = np.arange(len(region_a_tourists))  # x-coordinates for the bars
labels = ["Region A Tourists", "Region B Tourists"]  # Labels for the legend
title = "Tourists Distribution by Season"  # Title for the plot
xlabel = "Seasons"
seasons = ["Spring", "Summer", "Autumn", "Winter"]
ylim1 = [0, 100]  # y-axis limits for the first subplot
ylim2 = [0, 100]  # y-axis limits for the second subplot
yticks1 = [0, 25, 50, 75, 100]  # y-ticks for the first subplot
yticks2 = [0, 25, 50, 75, 100]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 6))

# Create the first subplot for 'region_a_tourists' using the left y-axis
color_a = "#2a9d8f"
color_b = "#e76f51"
ax1.bar(
    x - 0.2,
    region_a_tourists,
    width=0.4,
    label=labels[0],
    color=color_a,
    align="center",
)
ax1.set_ylabel(labels[0], color=color_a)
ax1.tick_params(axis="y", labelcolor=color_a)

# Create the second y-axis for 'region_b_tourists'
ax2 = ax1.twinx()
ax2.bar(
    x + 0.2,
    region_b_tourists,
    width=0.4,
    label=labels[1],
    color=color_b,
    align="center",
)
ax2.set_ylabel(labels[1], color=color_b)
ax2.tick_params(axis="y", labelcolor=color_b)

# Title for the plot
ax1.set_title(title)

# Set x-axis labels
ax1.set_xticks(x)
ax1.set_xticklabels(seasons)
ax1.set_xlabel(xlabel)

# Annotate bars with their values
for j in range(len(region_a_tourists)):
    ax1.text(
        x[j] - 0.2,
        region_a_tourists[j] + 1,
        f"{region_a_tourists[j]}k",
        ha="center",
        color="black",
    )
    ax2.text(
        x[j] + 0.2,
        region_b_tourists[j] + 1,
        f"{region_b_tourists[j]}k",
        ha="center",
        color="black",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)
# Add legend to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.15))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1.0, 1.15))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_304.pdf", bbox_inches="tight")

