

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate some example transportation data
categories = ["Cars", "Bikes", "Buses", "Trains", "Planes"]

# Data for the graph: positive values for user counts (in millions)
values1_A = [np.random.uniform(20, 100) for _ in categories]  # Current Year
values2_A = [np.random.uniform(20, 100) for _ in categories]  # Previous Year
labels = ["Current Year", "Previous Year"]
xlabel = "Modes of Transportation"
ylabel = "Number of Users (millions)"
title = "User Counts by Transportation Mode"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Make the bar plot with hatch patterns
color1_A = "lightblue"
color2_A = "salmon"
edgecolor1_A = "navy"
edgecolor2_A = "darkred"

ax.bar(
    categories,
    values1_A,
    color=color1_A,
    hatch="/",
    label="Current Year",
    edgecolor=edgecolor1_A,
)
ax.bar(
    categories,
    values2_A,
    color=color2_A,
    hatch="\\",
    label="Previous Year",
    bottom=values1_A,
    edgecolor=edgecolor2_A,
)

# Labeling and customizing
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis="y", linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_308.pdf", bbox_inches="tight")

