
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Example data for Transportation domain
seasons = ["Spring", "Summer", "Autumn", "Winter"]
passenger_growth_a = [15, 20, 12, 18] # Company A
passenger_growth_b = [10, 18, 14, 16] # Company B
freight_increase_a = [8, 12, 10, 15] # Company A
freight_increase_b = [6, 10, 9, 11] # Company B

n_groups = len(seasons)

labels = ["Passenger Growth A", "Passenger Growth B", "Freight Increase A", "Freight Increase B"]
xlabel = "Seasons"
ylabel = "Percentage Increase"
title = "Transportation Performance Over Four Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 5))

index = np.arange(n_groups)
bar_width = 0.2

opacity = 0.8

rects1 = ax.bar(
    index - 1.5 * bar_width,
    passenger_growth_a,
    bar_width,
    alpha=opacity,
    color="#2A9D8F",  # Teal
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    passenger_growth_b,
    bar_width,
    alpha=opacity,
    color="#264653",  # Dark Blue
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    freight_increase_a,
    bar_width,
    alpha=opacity,
    color="#E9C46A",  # Yellow
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    freight_increase_b,
    bar_width,
    alpha=opacity,
    color="#F4A261",  # Orange
    hatch="x",
    label=labels[3],
)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(index)
ax.set_xticklabels(seasons)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_318.pdf", bbox_inches="tight")
