

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example Data: Technology Trends
years = ["2018", "2019", "2020", "2021"]
market_share = [30, 35, 33, 40]          # Market Share (%)
user_growth_rate = [15, 12, 10, 8]       # User Growth Rate (%)
innovation_rate = [5, 6, 7, 9]           # Innovation Rate (%)
investment_rate = [20, 25, 18, 22]       # Investment Rate (%)

n_years = len(years)

labels = ["Market Share", "User Growth Rate", "Innovation Rate", "Investment Rate"]
xlabel = "Year"
ylabel = "Percentage (%)"
title = "Key Technology Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

index = np.arange(n_years)
bar_width = 0.2

opacity = 0.8

rects1 = ax.bar(
    index - 1.5 * bar_width,
    market_share,
    bar_width,
    alpha=opacity,
    color="#1b9e77",
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    user_growth_rate,
    bar_width,
    alpha=opacity,
    color="#d95f02",
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    innovation_rate,
    bar_width,
    alpha=opacity,
    color="#7570b3",
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    investment_rate,
    bar_width,
    alpha=opacity,
    color="#e7298a",
    hatch="///",
    label=labels[3],
)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(index)
ax.set_xticklabels(years)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_320.pdf", bbox_inches="tight")

