

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
N = 5
python = (0.4, 0.45, 0.35, 0.2)
javascript = (0.35, 0.4, 0.3, 0.15)
java = (0.15, 0.25, 0.3, 0.3)
cpp = (0.05, 0.05, 0.1, 0.2)
ruby = (0.05, 0.05, 0.05, 0.15)

ind = np.arange(4)  # the x locations for the groups
width = 0.15  # the width of the bars

# Axes Limits and Labels
ylabel_value = "Language Popularity Proportion"
xlabel_value = "Age Group"
title_value = "Programming Language Popularity Across Age Groups"
legend_labels = (
    "Python",
    "JavaScript",
    "Java",
    "C++",
    "Ruby",
)

# Adjust Area Limits and Labels
xlim_values = [-0.3, 3.7]
xticklabels = ("0-20", "21-40", "41-60", "61+")



# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 6))  # Adjusting figure size as per the given dimensions
ax = fig.add_subplot(111)
# Colors
colors = (
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
)
rects1 = ax.bar(ind, python, width, color=colors[0])
rects2 = ax.bar(ind + width, javascript, width, color=colors[1])
rects3 = ax.bar(ind + 2 * width, java, width, color=colors[2])
rects4 = ax.bar(ind + 3 * width, cpp, width, color=colors[3])
rects5 = ax.bar(ind + 4 * width, ruby, width, color=colors[4])

ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_xlim(xlim_values)
ax.set_xticks(ind + 2 * width)
ax.set_xticklabels(xticklabels)

ax.legend(
    (rects1[0], rects2[0], rects3[0], rects4[0], rects5[0]),
    legend_labels,
)

plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_83.pdf", bbox_inches="tight")

