
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time = np.arange(0, 45, 5)
os_windows = np.array([35, 32, 30, 28, 27, 25, 23, 20, 18])
os_mac = np.array([25, 26, 27, 28, 29, 30, 32, 33, 35])
os_linux = np.array([10, 11, 12, 13, 14, 16, 17, 18, 20])
os_android = np.array([15, 14, 14, 15, 15, 16, 15, 16, 17])
os_ios = np.array([15, 17, 17, 16, 15, 13, 13, 13, 10])
width = 2

barlabel = ["Windows", "MacOS", "Linux", "Android", "iOS"]
xlabel = "Time (Months)"
ylabel = "Market Share (%)"
title = "Operating System Market Share Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0, 10, 20, 30, 40]

# Colors
color_windows = "#1f77b4"
color_mac = "#ff7f0e"
color_linux = "#2ca02c"
color_android = "#d62728"
color_ios = "#9467bd"

# Stacked bar chart
plt.figure(figsize=(10, 6))  # Adjusting figure size for better visibility
plt.bar(time, os_windows, width, color=color_windows, label=barlabel[0])
plt.bar(time, os_mac, width, bottom=os_windows, color=color_mac, label=barlabel[1])
plt.bar(time, os_linux, width, bottom=os_windows + os_mac, color=color_linux, label=barlabel[2])
plt.bar(time, os_android, width, bottom=os_windows + os_mac + os_linux, color=color_android, label=barlabel[3])
plt.bar(time, os_ios, width, bottom=os_windows + os_mac + os_linux + os_android, color=color_ios, label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.2, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_85.pdf", bbox_inches="tight")
