
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time = np.arange(2000, 2021, 5)
religion_A = np.array([20, 22, 25, 28, 30])
religion_B = np.array([30, 28, 25, 22, 20])
religion_C = np.array([10, 12, 15, 18, 20])
religion_D = np.array([25, 25, 20, 20, 20])
religion_E = np.array([15, 13, 15, 12, 10])
width = 2

barlabel = ["Religion A", "Religion B", "Religion C", "Religion D", "Religion E"]
xlabel = "Year"
ylabel = "Popularity (%)"
title = "Religion Popularity Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [2000, 2005, 2010, 2015, 2020]

# Stacked bar chart
plt.figure(figsize=(10, 5))  # Adjusting figure size to match original image dimensions
plt.bar(time, religion_A, width, color="#e6194B", label=barlabel[0])
plt.bar(time, religion_B, width, bottom=religion_A, color="#3cb44b", label=barlabel[1])
plt.bar(time, religion_C, width, bottom=religion_A + religion_B, color="#ffe119", label=barlabel[2])
plt.bar(time, religion_D, width, bottom=religion_A + religion_B + religion_C, color="#4363d8", label=barlabel[3])
plt.bar(time, religion_E, width, bottom=religion_A + religion_B + religion_C + religion_D, color="#f58231", label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.4, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_86.pdf", bbox_inches="tight")
