
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each subplot
datasets = ["Early Adoption", "Mass Market", "Late Majority", "Laggards"]
models = ["Strategy A", "Strategy B", "Strategy C", "Strategy D"]
PLCC_data = {
    "Early Adoption": [0.92, 0.94, 0.91, 0.90],
    "Mass Market": [0.85, 0.88, 0.87, 0.86],
    "Late Majority": [0.75, 0.78, 0.76, 0.74],
    "Laggards": [0.65, 0.68, 0.67, 0.66],
}
SROCC_data = {
    "Early Adoption": [0.93, 0.95, 0.92, 0.91],
    "Mass Market": [0.86, 0.89, 0.88, 0.87],
    "Late Majority": [0.76, 0.79, 0.77, 0.75],
    "Laggards": [0.66, 0.69, 0.68, 0.67],
}
label = ["PLCC", "SROCC"]
ylabel = "Performance Metric"
title = "Technology Adoption Models"

lims = [(0.89, 0.96), (0.84, 0.90), (0.73, 0.80), (0.63, 0.70)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))

colors = ["#6A4C93", "#1982C4", "#8AC926", "#FF595E"]
# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(PLCC_data)):
        # PLCC bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            PLCC_data[dataset][j],
            width,
            label=label[0],
            color=colors[j],
            edgecolor="black",
        )
        # SROCC bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            SROCC_data[dataset][j],
            width,
            label=label[1],
            color=colors[j],
            edgecolor="black",
        )

    # Add some text for labels, title and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(label)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_87.pdf", bbox_inches="tight")
