
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New domain data - Weather Analysis
datasets = ["Temperature", "Humidity", "Wind Speed", "Precipitation"]
models = ["Winter", "Spring", "Summer", "Autumn"]
Morning_data = {
    "Temperature": [30, 50, 75, 55],
    "Humidity": [0.8, 0.6, 0.4, 0.7],
    "Wind Speed": [5, 10, 15, 10],
    "Precipitation": [0.1, 0.2, 0.0, 0.3],
}
Afternoon_data = {
    "Temperature": [35, 60, 85, 65],
    "Humidity": [0.75, 0.55, 0.35, 0.65],
    "Wind Speed": [7, 12, 20, 12],
    "Precipitation": [0.15, 0.25, 0.05, 0.35],
}
labels = ["Morning", "Afternoon"]
ylabel = "Metrics"
title = "Weather Conditions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
lims = [(25, 90), (0.3, 0.9), (0, 25), (0, 0.45)]

# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))

# Updated color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(Morning_data)):
        # Morning bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            Morning_data[dataset][j],
            width,
            label=labels[0],
            color=colors[j],
            edgecolor="grey",
        )
        # Afternoon bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            Afternoon_data[dataset][j],
            width,
            label=labels[1],
            color=colors[j],
            edgecolor="grey",
        )

    # Add some text for labels, title, and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(labels)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_88.pdf", bbox_inches="tight")
