

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
# Data for each subplot in the literature domain
datasets = ["Fantasy", "Mystery", "Romance", "Science Fiction"]
models = ["Model A", "Model B", "Model C", "Model D"]
PLCC_data = {
    "Fantasy": [0.85, 0.88, 0.91, 0.93],
    "Mystery": [0.70, 0.75, 0.79, 0.83],
    "Romance": [0.76, 0.80, 0.84, 0.87],
    "Science Fiction": [0.88, 0.91, 0.93, 0.95],
}
SROCC_data = {
    "Fantasy": [0.83, 0.86, 0.89, 0.92],
    "Mystery": [0.68, 0.73, 0.77, 0.81],
    "Romance": [0.74, 0.78, 0.82, 0.85],
    "Science Fiction": [0.86, 0.89, 0.92, 0.94],
}
label = ["PLCC", "SROCC"]
ylabel = "Correlation Values"
title = "Novel Genres"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
lims = [(0, 1.2), (0, 0.95), (0, 1), (0, 1)]

# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))  # Adjusted the figure size for better clarity

# Custom color scheme
colors = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072"]
# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(PLCC_data)):
        # PLCC bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            PLCC_data[dataset][j],
            width,
            label=label[0],
            color=colors[j],
            edgecolor="white",
        )
        # SROCC bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            SROCC_data[dataset][j],
            width,
            label=label[1],
            color=colors[j],
            edgecolor="white",
        )

    # Add some text for labels, title, and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(label)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_89.pdf", bbox_inches="tight")

